/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.data.Headers;
import com.endertech.minecraft.forge.data.ResourceType;
import com.endertech.minecraft.forge.data.ResponseContent;
import com.endertech.minecraft.forge.data.UserAgent;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

class ResourceLoader
implements Closeable {
    final CloseableHttpClient client;
    final String agent;
    final BasicCookieStore store;
    private final Map<URI, ResponseContent> cache;
    private final String[] domains;
    private final Optional<String> sec_ch_ua;
    private final int maxRedirects = 10;
    private final boolean debug;

    ResourceLoader(String agent, String cookies, boolean debug) {
        this.agent = agent;
        this.store = new BasicCookieStore();
        this.debug = debug;
        SSLContext context = this.createSSLContext();
        SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(context, this.getProtocols(context), this.getCiphers(context), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        this.client = HttpClientBuilder.create().useSystemProperties().setUserAgent(agent).setDefaultCookieStore((CookieStore)this.store).setSSLSocketFactory((LayeredConnectionSocketFactory)ssl).addInterceptorFirst(this::response).addInterceptorLast(this::request).build();
        Arrays.stream(cookies.split("; ")).map(KeyValuePair::parse).filter(pair -> !pair.isEmpty()).map(pair -> new BasicClientCookie(pair.key(), pair.value())).peek(cookie -> cookie.setDomain("forge.com")).forEach(arg_0 -> ((BasicCookieStore)this.store).addCookie(arg_0));
        this.cache = new ConcurrentHashMap<URI, ResponseContent>();
        this.domains = (String[])Stream.of("forge", "google", "cdn", "overwolf").map(host -> host + ".").toArray(String[]::new);
        this.sec_ch_ua = UserAgent.getSecChUA(agent);
    }

    ResponseContent load(URI page, Optional<URI> referer, boolean resources) {
        ResponseContent pageContent = this.getPage(page, referer, 0);
        if (resources) {
            this.getResources(pageContent, "href=\\\"([^\\\"]+?)\\\"", "src=\\\"([^\\\"]+?)\\\"", "url\\(\\'([^\\']+?)\\'\\)").stream().filter(content -> content.type == ResourceType.CSS).forEach(content -> this.getResources((ResponseContent)content, "(?s)url\\(\\\"([^\\\"]+?)\\\"\\)"));
        }
        return pageContent;
    }

    private RequestConfig createConfig(int timeout, boolean redirects) {
        return RequestConfig.custom().setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).setConnectTimeout(timeout).setRedirectsEnabled(redirects).setCookieSpec("standard").build();
    }

    private SSLContext createSSLContext() {
        try {
            KeyStore ks = KeyStore.getInstance("Windows-ROOT", "SunMSCAPI");
            ks.load(null);
            this.print("Loaded " + ks.size() + " certificates of " + ks.getType());
            return SSLContexts.custom().loadTrustMaterial(ks, null).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
            this.print("Failed to create SSL context (reason: " + ex.getMessage() + "). Using default");
            return SSLContexts.createSystemDefault();
        }
    }

    private String[] getProtocols(SSLContext context) {
        List<String> protocols = Arrays.asList("TLSv1.2", "TLSv1.3");
        return (String[])protocols.toArray(String[]::new);
    }

    private String[] getCiphers(SSLContext context) {
        Map allCiphers = Map.ofEntries(Map.entry(4865, "TLS_AES_128_GCM_SHA256"), Map.entry(4866, "TLS_AES_256_GCM_SHA384"), Map.entry(4867, "TLS_CHACHA20_POLY1305_SHA256"), Map.entry(47, "TLS_RSA_WITH_AES_128_CBC_SHA"), Map.entry(51, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA"), Map.entry(53, "TLS_RSA_WITH_AES_256_CBC_SHA"), Map.entry(57, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"), Map.entry(156, "TLS_RSA_WITH_AES_128_GCM_SHA256"), Map.entry(157, "TLS_RSA_WITH_AES_256_GCM_SHA384"), Map.entry(158, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"), Map.entry(159, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"), Map.entry(10, "TLS_RSA_WITH_3DES_EDE_CBC_SHA"), Map.entry(49162, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"), Map.entry(49161, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"), Map.entry(49171, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"), Map.entry(49172, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"), Map.entry(49195, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"), Map.entry(49196, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"), Map.entry(49199, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"), Map.entry(49200, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"), Map.entry(52392, "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256"), Map.entry(52393, "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256"));
        List<Integer> codes = UserAgent.isChrome(this.agent) ? List.of(4865, 4866, 4867, 49195, 49199, 49196, 49200, 52393, 52392, 49171, 49172, 156, 157, 47, 53) : List.of(4865, 4867, 4866, 49195, 49199, 52393, 52392, 49196, 49200, 49162, 49161, 49171, 49172, 156, 157, 47, 53);
        List ciphers = codes.stream().map(allCiphers::get).collect(Collectors.toList());
        if (UserAgent.isChrome(this.agent)) {
            String code = CommonString.getRandomChar("0123456789ABCDEF") + "A";
            String grease = CommonString.Joiner.with("_").join("TLS", "GREASE", code);
            ciphers.add(0, grease);
        }
        List<String> supportedCiphers = List.of(context.getSocketFactory().getSupportedCipherSuites());
        ciphers.removeIf(cipher -> !supportedCiphers.contains(cipher));
        this.print(ciphers.toString());
        return (String[])ciphers.toArray(String[]::new);
    }

    private Optional<String> getCookies(URI uri) {
        StringJoiner joiner = new StringJoiner("; ");
        String host = uri.getHost();
        for (Cookie cookie : this.store.getCookies()) {
            String domain = cookie.getDomain();
            if (host != null && domain != null && !host.contains(domain)) continue;
            joiner.add(cookie.getName() + "=" + cookie.getValue());
        }
        String result = joiner.toString();
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseContent getPage(URI link, Optional<URI> referer, int depth) {
        ResponseContent content = this.getCached(link).orElse(null);
        if (content != null) {
            this.print(content);
            return content;
        }
        RequestConfig config = this.createConfig(60000, false);
        HttpUriRequest request = RequestBuilder.get((URI)link).setConfig(config).build();
        ResourceType type = ResourceType.HTML;
        this.setHeaders(request, type, referer, depth > 0);
        try (CloseableHttpResponse response = this.client.execute(request);){
            content = ResponseContent.of(link, type, response);
            this.tryCache(content);
            this.print(content);
            if (content.isStatusOK()) return content;
            Header header = response.getFirstHeader("Location");
            if (header == null) return content;
            if (depth >= 10) return content;
            URI redirect = request.getURI().resolve(header.getValue());
            URI ref = referer.orElse(content.location);
            ResponseContent responseContent = this.getPage(redirect, Optional.of(ref), depth + 1);
            return responseContent;
        }
        catch (IOException e) {
            content = ResponseContent.error(link, type, e);
            this.print(content);
        }
        return content;
    }

    private Optional<ResponseContent> getCached(URI link) {
        return Optional.ofNullable(this.cache.get(link));
    }

    private boolean tryCache(ResponseContent content) {
        if (content.isStatusOK()) {
            content = ResponseContent.cached(content);
            if (content.type == ResourceType.IMAGE) {
                content = content.withNoData();
            }
            this.cache.put(content.location, content);
            return true;
        }
        return false;
    }

    private List<ResponseContent> getResources(ResponseContent content, String ... patterns) {
        return this.getLinks(content, patterns).stream().map(link -> {
            ResourceType type = this.getResourceType((URI)link).orElse(ResourceType.HTML);
            return this.getResource((URI)link, type, content.location);
        }).peek(this::print).filter(ResponseContent::isStatusOK).toList();
    }

    private ResponseContent getResource(URI link, ResourceType type, URI referer) {
        ResponseContent responseContent;
        block11: {
            if (type == ResourceType.HTML) {
                return ResponseContent.skipped(link, type);
            }
            if (!StringUtils.containsAny((CharSequence)link.getHost(), (CharSequence[])this.domains)) {
                return ResponseContent.skipped(link, type);
            }
            ResponseContent content = this.getCached(link).orElse(null);
            if (content != null) {
                return content;
            }
            RequestConfig config = this.createConfig(CommonMath.Random.between(2000, 4000), false);
            HttpUriRequest request = RequestBuilder.get((URI)link).setConfig(config).build();
            this.setHeaders(request, type, Optional.of(referer), false);
            CloseableHttpResponse response = this.client.execute(request);
            try {
                ResponseContent content2 = ResponseContent.of(link, type, response);
                this.tryCache(content2);
                responseContent = content2;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ResponseContent.error(link, type, e);
                }
            }
            response.close();
        }
        return responseContent;
    }

    private Optional<ResourceType> getResourceType(URI link) {
        String path = link.getPath();
        if (path == null || path.isEmpty() || StringUtils.endsWithAny((CharSequence)"/", (CharSequence[])new CharSequence[0])) {
            return Optional.of(ResourceType.HTML);
        }
        if (StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{".css", "custom-css"})) {
            return Optional.of(ResourceType.CSS);
        }
        if (StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{".jpg", ".png", ".gif", ".ico", ".svg", ".bmp"})) {
            return Optional.of(ResourceType.IMAGE);
        }
        if (StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{".js"})) {
            return Optional.of(ResourceType.SCRIPT);
        }
        if (StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"/js/"}) || StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"/js"})) {
            return Optional.of(ResourceType.SCRIPT);
        }
        return Optional.empty();
    }

    private List<URI> getLinks(ResponseContent content, String ... patterns) {
        String data = content.dataAsString();
        TreeMap paths = new TreeMap();
        Stream.of(patterns).map(regex -> Pattern.compile(regex).matcher(data)).forEach(matcher -> {
            while (matcher.find()) {
                paths.put(matcher.start(), matcher.group(1));
            }
        });
        return paths.values().stream().map(path -> {
            try {
                path = path.trim().replace(" ", "%20");
                return content.location.resolve((String)path);
            }
            catch (Exception e) {
                this.print(e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private boolean isPostMethod(HttpUriRequest request) {
        return request.getMethod().equalsIgnoreCase(HttpMethod.POST.name());
    }

    private void response(HttpResponse response, HttpContext context) {
        Object[] headers = response.getHeaders("set-cookie");
        this.print(Arrays.toString(headers));
    }

    private void request(HttpRequest request, HttpContext context) {
        for (Header header : request.getAllHeaders()) {
            if (!(header instanceof BufferedHeader)) continue;
            request.removeHeader(header);
        }
        this.print(Arrays.toString(request.getAllHeaders()));
    }

    private void setHeaders(HttpUriRequest request, ResourceType type, Optional<URI> referer, boolean redirect) {
        URI link = request.getURI();
        Optional<String> cookies = this.getCookies(link);
        Headers headers = UserAgent.isChrome(this.agent) ? Headers.chromeGet(this.agent, link, type, referer, cookies, this.sec_ch_ua) : Headers.firefoxGet(this.agent, link, type, referer, cookies);
        headers.asList().forEach(header -> request.setHeader(header.key(), header.value()));
    }

    private void print(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private void print(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        }
    }

    private void print(ResponseContent content) {
        this.print((content.type != ResourceType.HTML ? "     " : "") + "@" + content.type + ": " + content.status + " -> " + content.location);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        ForgeEndertech.developMsg("Client closed");
    }
}

